function [msg]=bef2lef(beFile,leFile,datatype)
%[msg]=bef2lef(beFile,leFile,datatype)
%translate little-endian file to big-endian file
%Input:
% beFile: file name of a big-endian file
% leFile: file name of a little-endian file
% datatype: see document of fread()
%Output:
% msg: a short message
%
%20040318, jdlee
%

if(nargin < 3),
  error('not enough input parameters');
end
    
fid = fopen(beFile,'rb','ieee-be');
a = fread(fid,datatype);
fclose(fid);

fid = fopen(leFile,'wb','ieee-le');
fwrite(fid,a,datatype);
fclose(fid);

msg='ok';

return